/*
 * $Id: rotatebitmap.c,v 1.4 2003/08/01 11:49:44 prussar Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2002, Mark Ian Lillywhite and Michael Nordstrom
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "rotatebitmap.h"

/* Rotate a 1-, 2-, 4-, 8- or 16-bit bitmap 90 degrees, CW or CCW */
/* The 1-bit version should be maximally optimized as it's used for all 
   text in rotated mode on OS 3.5+ */
void RotateBitmap
    (
    Int16   width,
    Int16   height,
    UInt8*  dest,
    UInt16  destRowBytes,
    UInt8*  src,
    UInt16  srcRowBytes,
    Boolean clockWise,
    UInt8   bitDepth
    )
{
    Int16  inX;
    Int16  inY;
    Int16  outX;
    UInt8  inMask;
    UInt8  outMask;
    UInt32 inOffset;
    UInt32 outOffsetStart;
    UInt32 outOffset;
    UInt8  maskBits;
    UInt8  maskX;
    UInt8  shiftX;
    UInt8  inShift;
    UInt8  outShift;
    UInt8  maskXshift;

    if ( width == 0 || height == 0 )
        return;

    if ( bitDepth < 8 ) {
        UInt32 length;
        UInt8* p;

        length = ( UInt32 ) destRowBytes * width;
        p      = dest;

        while ( length-- )
              *p++ = 0;
    }

    switch ( bitDepth ) {
        case 1:
            if ( clockWise ) {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset  = inX >> 3;
                    inMask    = 1 << ( 7 - ( inX & 7 ) );
                    outOffsetStart = inX * ( UInt32 ) destRowBytes;
                    /* outY = inX */
                    for ( outX = height - 1, inY = 0 ; inY < height ;
                                     inY++, outX--, inOffset += srcRowBytes ) {
                         outOffset = outOffsetStart + ( outX >> 3 );
                         outMask   = 1 << ( 7 - ( outX & 7 ) );
                         if ( src[ inOffset ] & inMask )
                             dest[ outOffset ] |= outMask;
                    }
                }
            }
            else {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset  = inX / 8;
                    inMask    = 1 << ( 7 - ( inX & 7 ) );
                    outOffsetStart = ( width - 1 - inX ) *
                                         ( UInt32 ) destRowBytes;
                    for ( inY = 0 ; inY < height ;
                                            inY++, inOffset += srcRowBytes ) {
                         /* outX = inY */
                         outOffset = outOffsetStart + inY / 8;
                         outMask   = 1 << ( 7 - ( inY & 7 ) );
                         if ( src[ inOffset ] & inMask )
                             dest[ outOffset ] |= outMask;
                         else
                             dest[ outOffset ] &= ~outMask;
                    }
                }
            }
            break;

        case 2:
        case 4:
            if ( bitDepth == 2 ) {
                shiftX     = 2;
                maskX      = 3;
                maskBits   = 0x80 + 0x40;
                maskXshift = 1;
            }
            else {
                /* bitDepth == 4 */
                shiftX     = 1;
                maskX      = 1;
                maskBits   = 0x80 + 0x40 + 0x20;
                maskXshift = 2;
            }

            if ( clockWise ) {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset = inX >> shiftX;
                    inShift  = ( inX & maskX ) << maskXshift;
                    inMask   = maskBits >> inShift;
                    outOffsetStart = inX * ( UInt32 ) destRowBytes;  
                    /* outY = inX */
                    for ( outX = height - 1, inY = 0 ; inY < height ; inY++, outX--,
                                                            inOffset += srcRowBytes ) {
                         outOffset = outOffsetStart + ( outX >> shiftX );
                         outShift  = ( outX & maskX ) << maskXshift;
                         dest[ outOffset ] |= ( ( src[ inOffset ] & inMask ) <<
                                                inShift ) >> outShift;
                    }
                }
            }
            else {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset  = inX >> shiftX;
                    inShift  = ( inX & maskX ) << maskXshift;
                    inMask   = maskBits >> inShift;
                    outOffsetStart = ( width - 1 - inX ) * 
                                         ( UInt32 ) destRowBytes;
                    for ( inY = 0 ; inY < height ; 
                              inY++, inOffset += srcRowBytes ) {
                         /* outX = inY */
                         outOffset = outOffsetStart + ( inY >> shiftX );
                         outShift  = ( inY & maskX ) << maskXshift;
                         dest[ outOffset ] |= ( ( src[ inOffset ] & inMask ) <<
                                                 inShift ) >> outShift;
                    }
                }
            }
            break;

        case 8:
            if ( width == 0 || height == 0 )
                return;

            if ( clockWise ) {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset = inX;
                    outOffsetStart = inX * ( UInt32 )destRowBytes;
                    /* outY = inX */
                    for ( outX = height - 1, inY = 0 ; inY < height ;
                               inY++, outX--, inOffset += srcRowBytes ) {
                         outOffset = outOffsetStart + outX;
                         dest[ outOffset ] = src[ inOffset ];
                    }
                }
            }
            else {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset  = inX;
                    outOffsetStart = ( width - 1 - inX ) *
                                          ( UInt32 )destRowBytes;
                    for ( inY = 0 ; inY < height ; 
                              inY++, inOffset += srcRowBytes ) {
                         /* outX = inY */
                         outOffset = outOffsetStart + inY;
                         dest[ outOffset ] = src[ inOffset ];
                    }
                }
            }
            break;

        case 16:
            if ( clockWise ) {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset = inX * 2;
                    outOffsetStart = inX * ( UInt32 ) destRowBytes;
                    /* outY = inX */
                    for ( outX = height - 1, inY = 0 ; inY < height ;
                               inY++, outX--, inOffset += srcRowBytes ) {
                         outOffset = outOffsetStart + outX * 2;
                         * ( UInt16* ) &dest[ outOffset ] = * ( UInt16* )
                                                              &src[ inOffset ];
                    }
                }
            }
            else {
                for ( inX = 0 ; inX < width ; inX ++ ) {
                    inOffset  = inX * 2;
                    outOffsetStart = ( width - 1 - inX ) *
                                        ( UInt32 ) destRowBytes;
                    for ( inY = 0 ; inY < height ; 
                              inY++, inOffset += srcRowBytes ) {
                         /* outX = inY */
                         outOffset = outOffsetStart + inY * 2;
                         * ( UInt16* ) &dest[ outOffset ] = * ( UInt16* )
                                                             &src[ inOffset ];
                    }
                }
            }
            break;
    }
}

